/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: EndDocument.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

import java.io.IOException;
import de.kxml.*;

/**
 * the END_DOCUMENT event
 */
public class EndDocument extends ParseEvent {

    /**
     * returns END_DOCUMENT
     */
    public int getType() {
	return Xml.END_DOCUMENT;
    } 

    /**
     * Method declaration
     *
     *
     * @param start
     *
     * @return
     *
     * @see
     */
    public boolean endCheck(StartTag start) {
	if (start != null) {
	    throw new RuntimeException("Unexpected end of document");
	} 

	return true;
    } 

}

